/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.items.CustomItem;
import noppes.npcs.util.Util;

public class CustomShield
extends ItemShield
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected ItemStack repairItemStack = ItemStack.field_190927_a;
    protected int enchantability = 0;
    protected Item.ToolMaterial material = Item.ToolMaterial.WOOD;

    public CustomShield(NBTTagCompound nbtItem) {
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        if (nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("Material", 8)) {
            this.material = CustomItem.getMaterialTool(nbtItem);
        }
        if (nbtItem.func_150297_b("RepairItem", 10)) {
            this.repairItemStack = new ItemStack(nbtItem.func_74775_l("RepairItem"));
        } else if (this.material != null) {
            this.repairItemStack = this.material.getRepairItemStack();
        }
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        this.func_77637_a(CustomRegisters.tabItems);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        ItemStack mat = this.repairItemStack;
        if (this.repairItemStack.func_190926_b()) {
            mat = this.material.getRepairItemStack();
        }
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        if (this.enchantability > 0) {
            return this.enchantability;
        }
        return super.func_77619_b();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return new TextComponentTranslation(this.func_77657_g(stack) + ".name", new Object[0]).func_150254_d();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return this.field_77789_bW;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 4;
    }
}

